//		Visualizador de los conjuntos de MANDELBROT, de JULIA y de PICKOVER con Zoom.
//		Applet programado por Pablo Lpez Cienfuegos con JDK 1.0.2.
//		CREADO......... 28/04/98.
//		MODIFICADO..... 28/05/98.

import java.awt.*;			//Biblioteca para la interface de usuario.
import java.applet.*;		//Biblioteca para el Applet.

public class dao extends Applet {
	//Defino dao como una subclase de la clase Applet.
	
	public String getAppletInfo(){
		//Preparo la informacin sobre el autor del Applet.
		
		return (	"\n"+
					"Applet programado para las prcticas de D.A.O. del curso 97/98.\n"+
					"\n"+
					"Desarrollado por Pablo Lpez Cienfuegos con JDK 1.0.2.\n"+
					"http://www.fortunecity.com/skyscraper/corel/284/\n"+
					"pablete.en.la.red@eudoramail.com\n"+
					"\n"+
					"CREADO\t\t28/04/98.\n"+
					"MODIFICADO\t28/05/98.");
	}
	
	//Declaracin de variables globales al Applet.
	
	double x1,y1,x2,y2;			//Vrtices del plano complejo a estudiar.
	double LONG_X = 400.0;		//La coordenada X oscila entre 0 y 400.
	double LONG_Y = 300.0;		//La coordenada Y oscila entre 0 y 300.
	
	int OPCION  = 1;				//Al iniciarse, el Applet muestra informacin sobre el autor.
	int AUMENTO	= 3;				//El Zoom aumenta el dibujo x3.
	int NMAX		= 75;				//N mximo de iteraciones.
	int COTA		= 5;				//Salida de rbita.
	int BORDE	= 100;			//Borde superior para el ttulo del Applet.
	
	//Fin de la declaracin de las variables globales.

	void botDibujar_Clicked(Event event) {
		//Funcin que gestiona la pulsacin del botn DIBUJAR.
		
		if(OPCION==5){
			//Tenemos que dibujar el conjunto de Julia.
			
			OPCION = 3;
		}
		else if(OPCION==6){
			//Tenemos que dibujar el conjunto de Pickover.
			
			OPCION = 4;
		}
		else if(OPCION==7){
			//Tenemos que dibujar el conjunto de Mandelbrot.
			
			OPCION = 2;
		}
		
		//Redibujamos el Applet.
		repaint();
	}

	void botPikover_Clicked(Event event) {
		//Funcin que gestiona la pulsacin del botn PICKOVER.
		
		OPCION = 6;
		
		//Plano complejo a explorar inicialmente.
		x1 = -2.0;
		y1 =  1.5;
		x2 =  2.0;
		y2 = -1.5;
		
		//Redibujamos el Applet.
		repaint();
	}

	void botJulia_Clicked(Event event){
		//Funcin que gestiona la pulsacin del botn JULIA.
		
		OPCION = 5;
		
		//Plano complejo a explorar inicialmente.
		x1 = -2.0;
		y1 =  1.5;
		x2 =  2.0;
		y2 = -1.5;
		
		//Redibujamos el Applet.
		repaint();
	}

	void botMandel_Clicked(Event event){
		//Funcin que gestiona la pulsacin del botn MANDELBROT.
		
		OPCION = 7;
		
		//Plano complejo a explorar inicialmente.
		x1 = -2.5;
		y1 =  1.5;
		x2 =  1.5;
		y2 = -1.5;
		
		//Redibujamos el Applet.
		repaint();
	}

	void botAutor_Clicked(Event event){
		//Funcin que gestiona la pulsacin del botn AUTOR.
		
		OPCION = 1;
		
		//Redibujamos el Applet.
		repaint();
	}

	void dao_MouseDown(Event evento){
		//Funcin que gestiona el manejo del Zoom con el ratn.
		
		if(OPCION!=1 && evento.clickCount==2 && !evento.metaDown()){
			//Manejamos el botn principal.(Incrementar el aumento).
			
			//Longitud de los lados del recinto a explorar actual.
			double xx = x2-x1;
			double yy = y2-y1;
			
			//Nuevos vrtices del recinto.
			x1 += xx*(evento.x-LONG_X/AUMENTO/2.)/LONG_X;
			y1 += yy*(evento.y-BORDE-LONG_Y/AUMENTO/2.)/LONG_Y;
			x2 = x1+xx/AUMENTO;
			y2 = y1+yy/AUMENTO;
			
			//Redibujamos el Applet.
			repaint();
		}
		else if(OPCION!=1 && evento.clickCount==2 && evento.metaDown()){
			//Manejamos el botn secundario.(Disminuir el aumento).
			
			//Longitud de los lados del recinto a explorar actual.
			double xx = x2-x1;
			double yy = y2-y1;
			
			//Nuevos vrtices del recinto.
			x1 += xx*(evento.x-LONG_X*AUMENTO/2.)/LONG_X;
			y1 += yy*(evento.y-BORDE-LONG_Y*AUMENTO/2.)/LONG_Y;
			x2 = x1+xx*AUMENTO;
			y2 = y1+yy*AUMENTO;
			
			//Redibujamos el Applet.
			repaint();
		}
	}

	public void init(){
		//Inicializacin del Applet.
		
		super.init();
		setLayout(null);
		addNotify();
		resize(550,400);
		setFont(new Font("Dialog", Font.PLAIN, 16));
		setBackground(new Color(2936787));
		
		//Definimos la etiqueta del ttulo.
		titulo = new java.awt.Label("Conjuntos de Mandelbrot, de Julia, y de Pickover.",Label.CENTER);
		titulo.reshape(25,0,500,25);
		titulo.setFont(new Font("Dialog", Font.BOLD, 18));
		add(titulo);
		
		//Definimos la etiqueta de los mensajes.
		mensaje = new java.awt.Label("",Label.CENTER);
		mensaje.reshape(25,25,500,20);
		mensaje.setFont(new Font("Dialog", Font.BOLD, 14));
		add(mensaje);
		
		//Definimos el botn que muestra la opcin de AUTOR.
		bot_autor = new java.awt.Button("Autor");
		bot_autor.reshape(420,160,110,25);
		bot_autor.setFont(new Font("Dialog", Font.BOLD, 16));
		add(bot_autor);
		
		//Definimos el botn que muestra la opcin de MANDELBROT.
		bot_mandel = new java.awt.Button("Mandelbrot");
		bot_mandel.reshape(420,220,110,25);
		bot_mandel.setFont(new Font("Dialog", Font.BOLD, 16));
		add(bot_mandel);
		
		//Definimos el botn que muestra la opcin de JULIA.
		bot_julia = new java.awt.Button("Julia");
		bot_julia.reshape(420,280,110,25);
		bot_julia.setFont(new Font("Dialog", Font.BOLD, 16));
		add(bot_julia);
		
		//Definimos el botn que muestra la opcin de PICKOVER.
		bot_pikover = new java.awt.Button("Pickover");
		bot_pikover.reshape(420,340,110,25);
		bot_pikover.setFont(new Font("Dialog", Font.BOLD, 16));
		add(bot_pikover);
		
		//Definimos el botn que muestra la opcin de DIBUJAR.
		bot_dibujar = new java.awt.Button("Dibujar");
		bot_dibujar.disable();
		bot_dibujar.reshape(420,70,110,25);
		bot_dibujar.setFont(new Font("Dialog", Font.BOLD, 16));
		add(bot_dibujar);
		
		//Definimos la entrada para la parte real de la semilla.
		text_real = new java.awt.TextField();
		text_real.setText("XXXXXXXXXX");
		text_real.reshape(40,70,100,25);
		add(text_real);
		
		//Definimos la entrada para la parte imaginaria de la semilla.
		text_imag = new java.awt.TextField();
		text_imag.setText("XXXXXXXXXX");
		text_imag.reshape(220,70,100,25);
		add(text_imag);
		
		//Definimos la etiqueta que identifica la entrada para la parte real.
		eti_real = new java.awt.Label("Parte real:");
		eti_real.reshape(40,50,130,20);
		eti_real.setFont(new Font("Dialog", Font.BOLD, 14));
		eti_real.setForeground(new Color(0));
		eti_real.setBackground(new Color(11029930));
		add(eti_real);
		
		//Definimos la etiqueta que identifica la entrada para la parte imaginaria.
		eti_imag = new java.awt.Label("Parte imaginaria:");
		eti_imag.reshape(220,50,130,20);
		eti_imag.setFont(new Font("Dialog", Font.BOLD, 14));
		eti_imag.setForeground(new Color(0));
		eti_imag.setBackground(new Color(11029930));
		add(eti_imag);
	}

	public boolean handleEvent(Event event) {
		//Funcin que redirige los eventos del Applet.

		if (event.target==this && event.id==Event.MOUSE_DOWN) {
			//Se produce una pulsacin de un botn del ratn.

			dao_MouseDown(event);
			return true;
		}
		if (event.target==bot_autor && event.id==Event.ACTION_EVENT) {
			//Se produce una pulsacin en el botn Autor.

			botAutor_Clicked(event);
			return true;
		}
		if (event.target==bot_mandel && event.id==Event.ACTION_EVENT) {
			//Se produce una pulsacin en el botn Mandelbrot.

			botMandel_Clicked(event);
			return true;
		}
		if (event.target==bot_julia && event.id==Event.ACTION_EVENT) {
			//Se produce una pulsacin en el botn Julia.

			botJulia_Clicked(event);
			return true;
		}
		if (event.target==bot_dibujar && event.id==Event.ACTION_EVENT) {
			//Se produce una pulsacin en el botn Dibujar.

			botDibujar_Clicked(event);
			return true;
		}
		if (event.target == bot_pikover && event.id == Event.ACTION_EVENT) {
			//Se produce una pulsacin en el botn Pickover.
			
			botPikover_Clicked(event);
			return true;
		}
		
		//Manejamos el resto de los eventos.
		return super.handleEvent(event);
	}
	
	//Declaramos los controles.
	java.awt.Label titulo;
	java.awt.Label mensaje;
	java.awt.Button bot_autor;
	java.awt.Button bot_mandel;
	java.awt.Button bot_julia;
	java.awt.Button bot_pikover;
	java.awt.Button bot_dibujar;
	java.awt.TextField text_real;
	java.awt.TextField text_imag;
	java.awt.Label eti_real;
	java.awt.Label eti_imag;
	
	public void paint(Graphics ARFS){
		//Funcin que pinta el Applet en pantalla.
		
		//ARFS es el objeto Graphics con el que voy a dibujar los conjuntos.
		
		//Defino un vector con los colores.
		int NUM_COLORES = 17;
		Color[] pinta = new Color[NUM_COLORES];
		
		//Puedo definir cada color as.
		pinta[0]  = Color.gray;
		pinta[1]  = new Color(209,225,17);
		pinta[2]  = Color.blue;
		pinta[3]  = Color.cyan;
		pinta[4]  = Color.darkGray;
		pinta[5]  = Color.pink;
		pinta[6]  = new Color(155,90,47);
		pinta[7]  = Color.green;
		pinta[8]  = Color.lightGray;
		pinta[9]  = Color.magenta;
		pinta[10] = new Color(58,184,62);
		pinta[11] = Color.yellow;
		pinta[12] = Color.orange;
		pinta[13] = Color.red;
		pinta[14] = new Color(186,35,207);
		pinta[15] = new Color(134,253,70);
		pinta[16] = Color.black;
		
		//Dibujo los rectngulos para contener los botones.
		ARFS.setColor(new Color(11029930));
		ARFS.fillRect(0,45,550,55);
		ARFS.fillRect((int)LONG_X,BORDE,150,(int)LONG_Y);

		if(OPCION==2 || OPCION==3 || OPCION==4){
			//Tengo que dibujar alguno de los conjuntos.
			
			//Desactivo el botn Dibujar, y las entradas de datos.
			bot_dibujar.disable();
			text_real.disable();
			text_imag.disable();
			
			//Dibujo un rectngulo negro que sirva de fondo al conjunto.
			ARFS.setColor(pinta[(NUM_COLORES-1)]);
			ARFS.fillRect(0,BORDE,(int)LONG_X,(int)LONG_Y);
		}
		
		if(OPCION==1){
			//Muestro la informacin sobre el autor.
			
			int sup = 130;			//Margen superior.
			int margen = 25;		//Margen izquierdo.

			mensaje.setText("Informacin del autor y del programa");
			
			//Desactivo los componentes que no necesito.
			bot_dibujar.disable();
			text_real.setText("XXXXXXXXXX");
			text_imag.setText("XXXXXXXXXX");
			text_real.disable();
			text_imag.disable();
			
			ARFS.setColor(Color.black);
			ARFS.drawRect(5,BORDE+5,(int)LONG_X-10,(int)LONG_Y-10);
			ARFS.drawRect(6,BORDE+6,(int)LONG_X-12,(int)LONG_Y-12);
			ARFS.drawString("<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>",margen,sup);
			ARFS.drawString("Programado por Pablo Lpez Cienfuegos.",margen,sup+20);
			ARFS.drawString("http://www.fortunecity.com/skyscraper/corel/284/",margen,sup+40);
			ARFS.drawString("e-mail: pablete.en.la.red@eudoramail.com",margen,sup+60);
			ARFS.drawString("",margen,sup+80);
			ARFS.drawString("1-. Pulse el botn del fractal a dibujar.",margen+20,sup+100);
			ARFS.drawString("2-. Elija los valores de la semilla del",margen+20,sup+120);
			ARFS.drawString("mtodo iterativo, y pulse DIBUJAR.",margen+50,sup+140);
			ARFS.drawString("3-. Haga doble clic con el botn principal",margen+20,sup+160);
			ARFS.drawString("para incrementar el zoom.",margen+50,sup+180);
			ARFS.drawString("4-. Haga doble clic con el botn secundario",margen+20,sup+200);
			ARFS.drawString("para disminuir el zoom.",margen+50,sup+220);
			ARFS.drawString("",margen,sup+240);
			ARFS.drawString("<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>",margen,sup+260);
		}
		else if(OPCION==2){
			//Conjunto de Mandelbrot.
			
			//Informo de que empiezo a dibujar.
			mensaje.setText("Dibujando el conjunto de Mandelbrot...");
			
			//Semilla del conjunto de Mandelbrot.
			Double real_aux = new Double(text_real.getText());
			double real = real_aux.doubleValue();
			Double imag_aux = new Double(text_imag.getText());
			double imag = imag_aux.doubleValue();
			
			//Comienzo el bucle en el que dibujo el conjunto de Mandelbrot.
			for(int ver=0;ver<LONG_Y;ver++){
				//La coordenada Y oscila entre 0 y 300.
				
				//Bi es la parte imaginaria del nmero complejo.
				double bi = ver/LONG_Y*(y2-y1)+y1;
				for(int hor=0;hor<LONG_X;hor++){
					//La coordenada X oscila entre 0 y 400.
					
					//A es la parte real del nmero complejo.
					double a = hor/LONG_X*(x2-x1)+x1;
					
					//Componentes del nmero complejo Z.
					double c1 = real,c2 = imag;
					
					//Variables auxiliares.
					int contador = 0;
					double norma_z = .0;
					double c_aux;
					
					while(norma_z<COTA && ++contador<NMAX){
						//Bucle en el que itero Z*Z+C.
						
						c_aux = c1;
						c1 = c1*c1-c2*c2+a;
						c2 = 2.*c_aux*c2+bi;
						
						//Norma del nmero complejo.
						norma_z = c1*c1+c2*c2;
					}
					if(norma_z>=COTA){
						//Salgo del bucle por superar la cota.
						
						//Slo quiero usar los NUM_COLORES-1 primeros colores de pinta.
						ARFS.setColor(pinta[contador%(NUM_COLORES-1)]);
						ARFS.drawLine(hor,ver+BORDE,hor,ver+BORDE);
					}
				}
			}
			
			//Fin del dibujado del conjunto.
			mensaje.setText("Conjunto de Mandelbrot finalizado.");
		}
		else if(OPCION==3){
			//Conjunto de Julia.
			
			//Informo de que empiezo a dibujar.
			mensaje.setText("Dibujando el conjunto de Julia...");
			
			//Declaro las variables auxiliares.
			int contador;
			
			//Semilla del conjunto de Julia.
			Double real_aux = new Double(text_real.getText());
			double real = real_aux.doubleValue();
			Double imag_aux = new Double(text_imag.getText());
			double imag = imag_aux.doubleValue();
			
			//Comienzo el bucle en el que dibujo el conjunto de Julia.
			for(int ver=0;ver<LONG_Y;ver++){
				//La coordenada Y oscila entre 0 y 300.
				
				for(int hor=0;hor<LONG_X;hor++){
					//La coordenada X oscila entre 0 y 400.
					
					//Variables auxiliares.
					double c1 = hor/LONG_X*(x2-x1)+x1;
					double c2 = ver/LONG_Y*(y2-y1)+y1;
					double c_aux;
					double norma_z = .0;
					contador = 0;
					
					while(norma_z<COTA && ++contador<NMAX){
						//Bucle en el que itero Z*Z+C.
						
						c_aux = c1;
						c1 = c1*c1-c2*c2+real;
						c2 = 2.*c_aux*c2+imag;
						
						//Norma del nmero complejo.
						norma_z = c1*c1+c2*c2;
					}
					if(norma_z>=COTA){
						//Salgo del bucle por superar la cota.
						
						//Slo quiero usar los NUM_COLORES-1 primeros colores de pinta.
						ARFS.setColor(pinta[contador%(NUM_COLORES-1)]);
						ARFS.drawLine(hor,ver+BORDE,hor,ver+BORDE);
					}
				}
			}
			
			//Fin del dibujado del conjunto.
			mensaje.setText("Conjunto de Julia finalizado.");
		}
		else if(OPCION==4){
			//Conjunto de Pickover.
			
			//Informo de que empiezo a dibujar.
			mensaje.setText("Dibujando el conjunto de Pickover...");
			
			//Declaro las variables auxiliares.
			int contador;
			
			//Semilla del conjunto de Pickover.
			Double real_aux = new Double(text_real.getText());
			double real = real_aux.doubleValue();
			Double imag_aux = new Double(text_imag.getText());
			double imag = imag_aux.doubleValue();
			
			//Comienzo el bucle en el que dibujo el conjunto de Pickover.
			for(int ver=0;ver<LONG_Y;ver++){
				//La coordenada Y oscila entre 0 y 300.
				
				for(int hor=0;hor<LONG_X;hor++){
					//La coordenada X oscila entre 0 y 400.
					
					//Variables auxiliares.
					double c1 = hor/LONG_X*(x2-x1)+x1;
					double c2 = ver/LONG_Y*(y2-y1)+y1;
					double c_aux;
					double norma_z = .0;
					contador = 0;
					
					while(norma_z<COTA && ++contador<NMAX){
						//Bucle en el que itero Z*Z*Z+C.
						
						c_aux = c1;
						c1 = c_aux*(c_aux*c_aux-c2*c2)-2.*c_aux*c2*c2+real;
						c2 = 2.*c_aux*c_aux*c2+c2*(c_aux*c_aux-c2*c2)+imag;
						
						//Norma del nmero complejo.
						norma_z = c1*c1+c2*c2;
					}
					if(norma_z>=COTA){
						//Salgo del bucle por superar la cota.
						
						//Slo quiero usar los NUM_COLORES-1 primeros colores de pinta.
						ARFS.setColor(pinta[contador%(NUM_COLORES-1)]);
						ARFS.drawLine(hor,ver+BORDE,hor,ver+BORDE);
					}
				}
			}
			
			//Fin del dibujado del conjunto.
			mensaje.setText("Conjunto de Pickover finalizado.");
		}
		else if(OPCION==5){
			//Opciones para la semilla de Julia.
			
			int sup = 130;			//Margen superior.
			int margen = 25;		//Margen izquierdo.
			
			mensaje.setText("Opciones del conjunto de Julia.");
			
			ARFS.setColor(Color.black);
			
			//Activo los elementos que necesito para dibujar el conjunto.
			bot_dibujar.enable();
			text_real.enable();
			text_imag.enable();
			text_real.setText("-0.9");
			text_imag.setText("0.0");
			
			ARFS.drawRect(5,BORDE+5,(int)LONG_X-10,(int)LONG_Y-10);
			ARFS.drawRect(6,BORDE+6,(int)LONG_X-12,(int)LONG_Y-12);
			ARFS.drawString("<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>",margen,sup);
			ARFS.drawString("",margen,sup+20);
			ARFS.drawString("Para representar el grfico del conjunto de Julia,",margen,sup+40);
			ARFS.drawString("introduzca en 'Parte real' y en 'Parte imaginaria',",margen,sup+60);
			ARFS.drawString("los valores que desee para la semilla del mtodo",margen,sup+80);
			ARFS.drawString("iterativo, (el valor de C en Z=Z^2+C), y pulse en",margen,sup+100);
			ARFS.drawString("el botn Dibujar.",margen,sup+120);
			ARFS.drawString("",margen,sup+140);
			ARFS.drawString("",margen,sup+160);
			ARFS.drawString("",margen,sup+180);
			ARFS.drawString("",margen,sup+200);
			ARFS.drawString("",margen,sup+220);
			ARFS.drawString("Programado por Pablo Lpez Cienfuegos.",margen+30,sup+240);
			ARFS.drawString("<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>",margen,sup+260);
		}
		else if(OPCION==6){
			//Opciones para la semilla de Pickover.
			
			int sup = 130;			//Margen superior.
			int margen = 25;		//Margen izquierdo.
			
			mensaje.setText("Opciones del conjunto de Pickover.");
			
			ARFS.setColor(Color.black);
			
			//Activo los elementos que necesito para dibujar el conjunto.
			bot_dibujar.enable();
			text_real.enable();
			text_imag.enable();
			text_real.setText("-0.7");
			text_imag.setText("0.2");
			
			ARFS.drawRect(5,BORDE+5,(int)LONG_X-10,(int)LONG_Y-10);
			ARFS.drawRect(6,BORDE+6,(int)LONG_X-12,(int)LONG_Y-12);
			ARFS.drawString("<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>",margen,sup);
			ARFS.drawString("",margen,sup+20);
			ARFS.drawString("Para representar el grfico del conjunto de Pickover,",margen,sup+40);
			ARFS.drawString("introduzca en 'Parte real' y en 'Parte imaginaria',",margen,sup+60);
			ARFS.drawString("los valores que desee para la semilla del mtodo",margen,sup+80);
			ARFS.drawString("iterativo, (el valor de C en Z=Z^3+C), y pulse en",margen,sup+100);
			ARFS.drawString("el botn Dibujar.",margen,sup+120);
			ARFS.drawString("",margen,sup+140);
			ARFS.drawString("",margen,sup+160);
			ARFS.drawString("",margen,sup+180);
			ARFS.drawString("",margen,sup+200);
			ARFS.drawString("",margen,sup+220);
			ARFS.drawString("Programado por Pablo Lpez Cienfuegos.",margen+30,sup+240);
			ARFS.drawString("<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>",margen,sup+260);
		}
		else if(OPCION==7){
			//Opciones para la semilla de Mandelbrot.
			
			int sup = 130;			//Margen superior.
			int margen = 25;		//Margen izquierdo.
			
			mensaje.setText("Opciones del conjunto de Mandelbrot.");
			
			ARFS.setColor(Color.black);
			
			//Activo los elementos que necesito para dibujar el conjunto.
			bot_dibujar.enable();
			text_real.enable();
			text_imag.enable();
			text_real.setText("0.0");
			text_imag.setText("0.0");
			
			ARFS.drawRect(5,BORDE+5,(int)LONG_X-10,(int)LONG_Y-10);
			ARFS.drawRect(6,BORDE+6,(int)LONG_X-12,(int)LONG_Y-12);
			ARFS.drawString("<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>",margen,sup);
			ARFS.drawString("",margen,sup+20);
			ARFS.drawString("Para representar el grfico del conjunto de",margen,sup+40);
			ARFS.drawString("Mandelbrot, introduzca en 'Parte real' y en 'Parte",margen,sup+60);
			ARFS.drawString("imaginaria', los valores que desee para la semilla del",margen,sup+80);
			ARFS.drawString("mtodo iterativo, (el valor inicial de Z en Z=Z^2+C), y",margen,sup+100);
			ARFS.drawString("pulse en el botn Dibujar.",margen,sup+120);
			ARFS.drawString("",margen,sup+140);
			ARFS.drawString("",margen,sup+160);
			ARFS.drawString("",margen,sup+180);
			ARFS.drawString("",margen,sup+200);
			ARFS.drawString("",margen,sup+220);
			ARFS.drawString("Programado por Pablo Lpez Cienfuegos.",margen+30,sup+240);
			ARFS.drawString("<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>",margen,sup+260);
		}
	}
//Fin del Applet dao.
}
